
///////////////////////////////////////////////////////////////////////////////
//
//   CONEXANT SYSTEMS INC - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1306.C - Message 1306 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1306 messages.
//
//   Originator : Hao Q. Phung
//   REVISION HISTORY
//
//
//   $Log:   V:\Projects\Labmon\Source\Archives\msg1306.c_v  $ 
//   
//      Rev 1.0   08 Dec 1999 14:42:44   dangmk
//    
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

void wait(float);  
void clear_message_line(void);   

/* not needed yet
////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1306 message from the ZMsgBuf.
//
void Dec1306(tMSGBUF *ZMsgBuf, tMSG1304 *Msg)
{
; // whatever
}                                      

end not needed yet */
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1306 message in the ZMsgBuf.
//
void Bld1306(tMSGBUF *ZMsgBuf, tMSG1306 *Msg)
{
 
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                         , ZMsgBuf, 1);     // message preamble
   PutShort  (1306                           , ZMsgBuf, 2);     // message number
   PutShort  (5                              , ZMsgBuf, 3);     // message length
   PutShort  (ANREQ                          , ZMsgBuf, 4);     // message ack/nack request
}                                            

